function effective_corr_ms = prep_effcorr_ms_data(cv2_local,fir,max_cor)
cv2_local_all = 0.05:0.05:2;
fir_all = 0.1:1:250;
bin_kass_length = 10; %%% 10 ms kass method bin
max_k = floor(max_cor/bin_kass_length)-1;
try
    full_file_path = [fileparts(which('prep_effcorr_ms_data')),...
        '/prep_best_cor_ms.mat'];
    load(full_file_path,'prep_best_cor_ms');
catch
    disp('Warning!_pre_mat_is not computed');
    prep_best_cor_ms = ...
        prep_best_k_dataset(cv2_local_all,fir_all,...
        bin_kass_length,max_k);
    save('./prep_best_cor_ms.mat');
end
cv_num = find(cv2_local>cv2_local_all,1,'last');
fir_num = find(fir>fir_all,1,'last');
if isempty(fir_num)
    disp('Warning! Low firing rate');
    fir_num = 1;
end
if isempty(cv_num)
    disp('Warning! Low CV2_local');
    cv_num = 1;
end
effective_corr_ms = prep_best_cor_ms(cv_num,fir_num);

end

function prep_best_cor_ms = prep_best_k_dataset(cv2_local_all,fir_all,...
    bin_kass_length,max_k)
prep_best_cor_ms = zeros(length(cv2_local_all),length(fir_all));
for cv_num=1:length(cv2_local_all)
    cv_temp = cv2_local_all(cv_num);
    parfor fir_num =1:length(fir_all)
        prep_best_cor_ms(cv_num,fir_num) = find_best_k(cv_temp,...
            fir_all(fir_num),bin_kass_length,max_k) * bin_kass_length;
    end
end
end


